@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#! /c/Perl/bin//perl -w
#line 15
#
# -*- Perl -*-
#
# rfnmz - Reindex NMZ.field.* files.
#
# Copyright (C) 2000 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#

use strict;
use FileHandle;
die "usage: rfnmz <index>\n" if @ARGV == 0;

my $target = $ARGV[0];
die "invalid target: $target\n" unless -d $target;

chdir $target;
my @fields = grep {! /\.i$/} glob 'NMZ.field.*';

for my $field (@fields) {
    my $fh_in = new FileHandle;
    $fh_in->open($field) || die "$field: $!";
    binmode($fh_in);

    my $fh_out = new FileHandle;
    $fh_out->open(">$field.i") || die "$field: $!";
    binmode($fh_out);

    my $ptr = 0;
    while (<$fh_in>) {
	print $fh_out pack 'N', $ptr;
	$ptr += length;
    }
}


__END__
:endofperl
